/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import com.ibm.hwmca.fw.util.Trace;

public class ByteArray {
    private static final String TRACE_MASKT = "XUTLBA T";
    private static final String TRACE_MASKF = "XUTLBA F";
    private static final String TRACE_MASKD = "XUTLBA D";
    public static final byte[] zeroBytes = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final char[] EBCDICCHARS = new char[]{'_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', ' ', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '+', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', ';', '_', '-', '/', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', ':', '_', '_', '_', '_', '_', '_', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '_', '_', '_', '_', '_', '_', '_', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '_', '_', '_', '_', '_', '_', '_', '_', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '_', '_', '_', '_', '_', '_', '_', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '_', '_', '_', '_', '_', '_', '_', '_', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '_', '_', '_', '_', '_', '_', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '_', '_', '_', '_', '_', '_'};

    public static byte[] extractBytes(byte[] theArray, int offset, int numBytes, boolean swapBytes) {
        byte[] sub = new byte[numBytes];
        if (swapBytes) {
            int i = 0;
            while (i < numBytes && offset + numBytes - 1 - i >= 0) {
                sub[i] = theArray[offset + numBytes - 1 - i];
                ++i;
            }
        } else {
            int i = 0;
            while (i < numBytes && i + offset < theArray.length) {
                sub[i] = theArray[offset + i];
                ++i;
            }
        }
        return sub;
    }

    public static short extractU8(byte[] theArray, int offset) {
        return (short)(theArray[offset] & 0xFF);
    }

    public static int extractU16(byte[] theArray, int offset, boolean swapBytes) {
        int theValue;
        if (swapBytes) {
            theValue = (theArray[offset + 1] & 0xFF) << 8;
            theValue += theArray[offset] & 0xFF;
        } else {
            theValue = (theArray[offset] & 0xFF) << 8;
            theValue += theArray[offset + 1] & 0xFF;
        }
        return theValue;
    }

    public static short extractS16(byte[] theArray, int offset, boolean swapBytes) {
        return (short)ByteArray.extractU16(theArray, offset, swapBytes);
    }

    public static long extractU32(byte[] theArray, int offset, boolean swapBytes) {
        long theValue;
        if (swapBytes) {
            theValue = ((long)theArray[offset + 3] & 0xFFL) << 24;
            theValue += ((long)theArray[offset + 2] & 0xFFL) << 16;
            theValue += ((long)theArray[offset + 1] & 0xFFL) << 8;
            theValue += (long)theArray[offset] & 0xFFL;
        } else {
            theValue = ((long)theArray[offset] & 0xFFL) << 24;
            theValue += ((long)theArray[offset + 1] & 0xFFL) << 16;
            theValue += ((long)theArray[offset + 2] & 0xFFL) << 8;
            theValue += (long)theArray[offset + 3] & 0xFFL;
        }
        return theValue;
    }

    public static int extractS32(byte[] theArray, int offset, boolean swapBytes) {
        return (int)ByteArray.extractU32(theArray, offset, swapBytes);
    }

    public static String extractString(byte[] theArray, int offset, int maxLen) {
        int stringEnd = offset + maxLen - 1;
        if (stringEnd >= theArray.length) {
            stringEnd = theArray.length - 1;
        }
        while (stringEnd >= offset) {
            if (theArray[stringEnd] != 0) break;
            --stringEnd;
        }
        int stringLen = stringEnd - offset + 1;
        return new String(theArray, offset, stringLen);
    }

    public static String extractNullString(byte[] array, int offset) {
        int nullAt = 0;
        int i = 0;
        while (i < array.length - offset) {
            if (array[offset + i] == 0) break;
            ++nullAt;
            ++i;
        }
        if (nullAt == 0) {
            return "";
        }
        Trace.trace(TRACE_MASKD, "nullat " + nullAt);
        return ByteArray.extractString(array, offset, nullAt + 1);
    }

    public static boolean compare(byte[] first, byte[] second) {
        int count = 0;
        while (count < first.length && first[count] == second[count]) {
            ++count;
        }
        return count == first.length;
    }

    public static boolean compare(byte[] first, byte[] second, byte[] mask, int size) {
        int count = 0;
        while (count < size && (first[count] & mask[count]) == (second[count] & mask[count])) {
            ++count;
        }
        return count == size;
    }

    public static boolean isEbcdicAlnum(byte[] src, int offset, int length) {
        int i = offset;
        while (i < offset + length) {
            int idx = src[i];
            if (idx >= 0) {
                return false;
            }
            if (EBCDICCHARS[idx += 256] == '_') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEbcdicAlnum(byte[] src) {
        return ByteArray.isEbcdicAlnum(src, 0, src.length);
    }
}

